/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIAggroLook;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIFollowOwner;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIStareAttack;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAITarget;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIWander;
import com.iafenvoy.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.iafenvoy.iceandfire.entity.ai.IAFLookHelper;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class EntityCockatrice
extends class_1321
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_JUMPAT = Animation.create((int)30);
    public static final Animation ANIMATION_WATTLESHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_EAT = Animation.create((int)20);
    public static final float VIEW_RADIUS = 0.6f;
    private static final class_2940<Boolean> HEN = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> STARING = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TARGET_ENTITY = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TAMING_PLAYER = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TAMING_LEVEL = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> COMMAND = class_2945.method_12791(EntityCockatrice.class, (class_2941)class_2943.field_13327);
    private final CockatriceAIStareAttack aiStare;
    private final class_1366 aiMelee;
    public float sitProgress;
    public float stareProgress;
    public int ticksStaring = 0;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isSitting;
    private boolean isStaring;
    private boolean isMeleeMode = false;
    private class_1309 targetedEntity;
    private int clientSideAttackTime;

    public EntityCockatrice(class_1299<EntityCockatrice> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6206 = new IAFLookHelper((class_1308)this);
        this.aiStare = new CockatriceAIStareAttack(this, 1.0, 0, 15.0f);
        this.aiMelee = new EntityAIAttackMeleeNoCooldown((class_1314)this, 1.5, false);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.cockatrice.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23724, 2.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.cockatrice.maxHealth.getValue()).doubleValue());
    }

    public int method_6110() {
        return 10;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new CockatriceAIFollowOwner(this, 1.0, 7.0f, 2.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1309.class, 14.0f, 1.0, 1.0, (Predicate)((com.google.common.base.Predicate)entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return !player.method_7337() && !entity.method_7325();
            }
            return entity.method_5864().method_20210(IafEntityTags.SCARES_COCKATRICES) && !entity.method_5864().method_20210(IafEntityTags.CHICKENS);
        })));
        this.field_6201.method_6277(4, (class_1352)new CockatriceAIWander(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new CockatriceAIAggroLook(this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1309.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new CockatriceAITargetItems(this, false));
        this.field_6185.method_6277(2, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(5, new CockatriceAITarget<class_1309>(this, class_1309.class, true, entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return !player.method_7337() && !entity.method_7325();
            }
            return entity instanceof class_1569 && this.method_6181() && !(entity instanceof class_1548) && !(entity instanceof class_1590) && !(entity instanceof class_1560) || entity.method_5864().method_20210(IafEntityTags.COCKATRICE_TARGETS) && !entity.method_5864().method_20210(IafEntityTags.CHICKENS);
        }));
    }

    public boolean method_18410() {
        return this.hasHomePosition && this.getCommand() == 3 && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.method_37908())) || super.method_18410();
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public class_2338 method_18412() {
        return this.hasHomePosition && this.getCommand() == 3 && this.homePos != null ? this.homePos.getPosition() : super.method_18412();
    }

    public float method_18413() {
        return 30.0f;
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean method_5722(class_1297 entityIn) {
        if (entityIn.method_5864().method_20210(IafEntityTags.CHICKENS)) {
            return true;
        }
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                class_1321 tameable = (class_1321)entityIn;
                return tameable.method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    public boolean method_5643(class_1282 source, float damage) {
        class_1297 entity;
        if (source.method_5529() != null && (entity = source.method_5529()).method_5864().method_20210(IafEntityTags.SCARES_COCKATRICES)) {
            damage *= 5.0f;
        }
        if (source == this.method_37908().method_48963().method_48822()) {
            return false;
        }
        return super.method_5643(source, damage);
    }

    private boolean canUseStareOn(class_1297 entity) {
        IBlacklistedFromStatues statues;
        return (!(entity instanceof IBlacklistedFromStatues) || (statues = (IBlacklistedFromStatues)entity).canBeTurnedToStone()) && !entity.method_5864().method_20210(IafEntityTags.COCKATRICE_TARGETS);
    }

    private void switchAI(boolean melee) {
        if (melee) {
            this.field_6201.method_6280((class_1352)this.aiStare);
            if (this.aiMelee != null) {
                this.field_6201.method_6277(2, (class_1352)this.aiMelee);
            }
            this.isMeleeMode = true;
        } else {
            this.field_6201.method_6280((class_1352)this.aiMelee);
            if (this.aiStare != null) {
                this.field_6201.method_6277(2, (class_1352)this.aiStare);
            }
            this.isMeleeMode = false;
        }
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.isStaring()) {
            return false;
        }
        if (this.method_6051().method_43056()) {
            if (this.getAnimation() != ANIMATION_JUMPAT && this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_JUMPAT);
            }
        } else if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_JUMPAT) {
            this.setAnimation(ANIMATION_BITE);
        }
        return false;
    }

    public boolean canMove() {
        return !this.method_24345() && (this.getAnimation() != ANIMATION_JUMPAT || this.getAnimationTick() >= 7);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEN, (Object)Boolean.FALSE);
        this.field_6011.method_12784(STARING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(TARGET_ENTITY, (Object)0);
        this.field_6011.method_12784(TAMING_PLAYER, (Object)0);
        this.field_6011.method_12784(TAMING_LEVEL, (Object)0);
        this.field_6011.method_12784(COMMAND, (Object)0);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_6011.method_12789(TARGET_ENTITY) != 0;
    }

    public boolean hasTamingPlayer() {
        return (Integer)this.field_6011.method_12789(TAMING_PLAYER) != 0;
    }

    public class_1297 getTamingPlayer() {
        if (!this.hasTamingPlayer()) {
            return null;
        }
        if (this.method_37908().field_9236) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            class_1297 entity = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TAMING_PLAYER)).intValue());
            if (entity instanceof class_1309) {
                class_1309 livingEntity;
                this.targetedEntity = livingEntity = (class_1309)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TAMING_PLAYER)).intValue());
    }

    public void setTamingPlayer(int entityId) {
        this.field_6011.method_12778(TAMING_PLAYER, (Object)entityId);
    }

    public class_1309 getTargetedEntity() {
        boolean blindness;
        boolean bl = blindness = this.method_6059(class_1294.field_5919) || this.method_5968() != null && this.method_5968().method_6059(class_1294.field_5919) || EntityGorgon.isBlindfolded(this.method_5968());
        if (blindness) {
            return null;
        }
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.method_37908().field_9236) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            class_1297 entity = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TARGET_ENTITY)).intValue());
            if (entity instanceof class_1309) {
                class_1309 livingEntity;
                this.targetedEntity = livingEntity = (class_1309)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.method_5968();
    }

    public void setTargetedEntity(int entityId) {
        this.field_6011.method_12778(TARGET_ENTITY, (Object)entityId);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Hen", this.isHen());
        tag.method_10556("Staring", this.isStaring());
        tag.method_10569("TamingLevel", this.getTamingLevel());
        tag.method_10569("TamingPlayer", ((Integer)this.field_6011.method_12789(TAMING_PLAYER)).intValue());
        tag.method_10569("Command", this.getCommand());
        tag.method_10556("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(tag);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setHen(tag.method_10577("Hen"));
        this.setStaring(tag.method_10577("Staring"));
        this.setTamingLevel(tag.method_10550("TamingLevel"));
        this.setTamingPlayer(tag.method_10550("TamingPlayer"));
        this.setCommand(tag.method_10550("Command"));
        this.hasHomePosition = tag.method_10577("HasHomePosition");
        if (this.hasHomePosition && tag.method_10550("HomeAreaX") != 0 && tag.method_10550("HomeAreaY") != 0 && tag.method_10550("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(tag, this.method_37908());
        }
        this.setConfigurableAttributes();
    }

    public boolean method_24345() {
        if (this.method_37908().field_9236) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_6011.method_12789(field_6322) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void method_24346(boolean sitting) {
        super.method_5796(sitting);
        if (!this.method_37908().field_9236) {
            this.isSitting = sitting;
        }
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHen(this.method_6051().method_43056());
        return spawnDataIn;
    }

    public boolean isHen() {
        return (Boolean)this.field_6011.method_12789(HEN);
    }

    public void setHen(boolean hen) {
        this.field_6011.method_12778(HEN, (Object)hen);
    }

    public int getTamingLevel() {
        return (Integer)this.field_6011.method_12789(TAMING_LEVEL);
    }

    public void setTamingLevel(int level) {
        this.field_6011.method_12778(TAMING_LEVEL, (Object)level);
    }

    public int getCommand() {
        return (Integer)this.field_6011.method_12789(COMMAND);
    }

    public void setCommand(int command) {
        this.field_6011.method_12778(COMMAND, (Object)command);
        this.method_24346(command == 1);
    }

    public boolean isStaring() {
        if (this.method_37908().field_9236) {
            this.isStaring = (Boolean)this.field_6011.method_12789(STARING);
            return this.isStaring;
        }
        return this.isStaring;
    }

    public void setStaring(boolean staring) {
        this.field_6011.method_12778(STARING, (Object)staring);
        if (!this.method_37908().field_9236) {
            this.isStaring = staring;
        }
    }

    public void forcePreyToLook(class_1308 mob) {
        mob.method_5988().method_6230(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), (float)mob.method_5986(), (float)mob.method_5978());
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        class_1792 itemInHand = stackInHand.method_7909();
        if (stackInHand.method_7909() == class_1802.field_8448 || itemInHand == class_1802.field_8719 || itemInHand == class_1802.field_8635) {
            return super.method_5992(player, hand);
        }
        if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (stackInHand.method_31573(IafItemTags.HEAL_COCKATRICE)) {
                if (this.method_6032() < this.method_6063()) {
                    this.method_6025(8.0f);
                    this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                    stackInHand.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (stackInHand.method_7960()) {
                if (player.method_5715()) {
                    if (this.hasHomePosition) {
                        this.hasHomePosition = false;
                        player.method_7353((class_2561)class_2561.method_43471((String)"cockatrice.command.remove_home"), true);
                    } else {
                        class_2338 pos = this.method_24515();
                        this.homePos = new HomePosition(pos, this.method_37908());
                        this.hasHomePosition = true;
                        player.method_7353((class_2561)class_2561.method_43469((String)"cockatrice.command.new_home", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.homePos.getDimension()}), true);
                    }
                } else {
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 3) {
                        this.setCommand(0);
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)("cockatrice.command." + this.getCommand())), true);
                    this.method_5783(class_3417.field_14986, 1.0f, 1.0f);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public void method_6007() {
        boolean blindness;
        boolean sitting;
        double dist;
        super.method_6007();
        class_1309 attackTarget = this.method_5968();
        if (this.method_37908().method_8407() == class_1267.field_5801 && attackTarget instanceof class_1657) {
            this.method_5980(null);
        }
        if (this.method_24345() && this.getCommand() != 1) {
            this.method_24346(false);
        }
        if (this.method_24345() && attackTarget != null) {
            this.method_5980(null);
        }
        if (attackTarget != null && this.method_5722((class_1297)attackTarget)) {
            this.method_5980(null);
        }
        if (!this.method_37908().field_9236) {
            if (attackTarget == null || !attackTarget.method_5805()) {
                this.setTargetedEntity(0);
            } else if (this.isStaring() || this.shouldStareAttack((class_1297)attackTarget)) {
                this.setTargetedEntity(attackTarget.method_5628());
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && attackTarget != null && this.getAnimationTick() == 7 && (dist = this.method_5858((class_1297)attackTarget)) < 8.0) {
            attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
        }
        if (this.getAnimation() == ANIMATION_JUMPAT && attackTarget != null) {
            dist = this.method_5858((class_1297)attackTarget);
            double d0 = attackTarget.method_23317() - this.method_23317();
            double d1 = attackTarget.method_23321() - this.method_23321();
            float leap = class_3532.method_15355((float)((float)(d0 * d0 + d1 * d1)));
            if (dist < 4.0 && this.getAnimationTick() > 10) {
                attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
                if ((double)leap >= 1.0E-4) {
                    attackTarget.method_18799(attackTarget.method_18798().method_1031(d0 / (double)leap * (double)0.8f + this.method_18798().field_1352 * (double)0.2f, 0.0, d1 / (double)leap * (double)0.8f + this.method_18798().field_1350 * (double)0.2f));
                }
            }
        }
        if ((sitting = this.method_24345()) && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean staring = this.isStaring();
        if (staring && this.stareProgress < 20.0f) {
            this.stareProgress += 0.5f;
        } else if (!staring && this.stareProgress > 0.0f) {
            this.stareProgress -= 0.5f;
        }
        if (!this.method_37908().field_9236) {
            this.ticksStaring = staring ? ++this.ticksStaring : 0;
        }
        if (!this.method_37908().field_9236 && staring && (attackTarget == null || this.shouldMelee())) {
            this.setStaring(false);
        }
        if (attackTarget != null) {
            this.method_5988().method_6230(attackTarget.method_23317(), attackTarget.method_23318() + (double)attackTarget.method_5751(), attackTarget.method_23321(), (float)this.method_5986(), (float)this.method_5978());
            if (!this.shouldMelee() && attackTarget instanceof class_1308) {
                class_1308 mob = (class_1308)attackTarget;
                this.forcePreyToLook(mob);
            }
        }
        boolean bl = blindness = this.method_6059(class_1294.field_5919) || attackTarget != null && attackTarget.method_6059(class_1294.field_5919);
        if (blindness) {
            this.setStaring(false);
        }
        if (!this.method_37908().field_9236 && !blindness && attackTarget != null && EntityGorgon.isEntityLookingAt((class_1309)this, attackTarget, 0.6f) && EntityGorgon.isEntityLookingAt(attackTarget, (class_1309)this, 0.6f) && !EntityGorgon.isBlindfolded(attackTarget) && !this.shouldMelee()) {
            if (!this.isStaring()) {
                this.setStaring(true);
            } else {
                int attackStrength = this.getFriendsCount(attackTarget);
                if (this.method_37908().method_8407() == class_1267.field_5807) {
                    ++attackStrength;
                }
                attackTarget.method_6092(new class_1293(class_1294.field_5920, 10, 2 + Math.min(1, attackStrength)));
                attackTarget.method_6092(new class_1293(class_1294.field_5909, 10, Math.min(4, attackStrength)));
                attackTarget.method_6092(new class_1293(class_1294.field_5916, 200, 0));
                if (attackStrength >= 2 && attackTarget.field_6012 % 40 == 0) {
                    attackTarget.method_5643(this.method_37908().method_48963().method_48832(), (float)(attackStrength - 1));
                }
                attackTarget.method_6015((class_1309)this);
                if (!this.method_6181() && attackTarget instanceof class_1657) {
                    this.setTamingPlayer(attackTarget.method_5628());
                    this.setTamingLevel(this.getTamingLevel() + 1);
                    if (this.getTamingLevel() % 100 == 0) {
                        this.method_37908().method_8421((class_1297)this, (byte)46);
                    }
                    if (this.getTamingLevel() >= 1000) {
                        this.method_37908().method_8421((class_1297)this, (byte)45);
                        class_1297 class_12972 = this.getTamingPlayer();
                        if (class_12972 instanceof class_1657) {
                            class_1657 player = (class_1657)class_12972;
                            this.method_6170(player);
                        }
                        this.method_5980(null);
                        this.setTamingPlayer(0);
                        this.setTargetedEntity(0);
                    }
                }
            }
        }
        if (!this.method_37908().field_9236 && attackTarget == null && this.method_6051().method_43048(300) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_WATTLESHAKE);
        }
        if (!this.method_37908().field_9236) {
            if (this.shouldMelee() && !this.isMeleeMode) {
                this.switchAI(true);
            }
            if (!this.shouldMelee() && this.isMeleeMode) {
                this.switchAI(false);
            }
        }
        if (this.method_37908().field_9236 && this.getTargetedEntity() != null && EntityGorgon.isEntityLookingAt((class_1309)this, this.getTargetedEntity(), 0.6f) && EntityGorgon.isEntityLookingAt(this.getTargetedEntity(), (class_1309)this, 0.6f) && this.isStaring() && this.hasTargetedEntity()) {
            class_1309 livingEntity;
            if (this.clientSideAttackTime < this.getAttackDuration()) {
                ++this.clientSideAttackTime;
            }
            if ((livingEntity = this.getTargetedEntity()) != null) {
                this.method_5988().method_6226((class_1297)livingEntity, 90.0f, 90.0f);
                this.method_5988().method_6231();
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = livingEntity.method_23317() - this.method_23317();
                double d1 = livingEntity.method_23318() + (double)(livingEntity.method_17682() * 0.5f) - (this.method_23318() + (double)this.method_5751());
                double d2 = livingEntity.method_23321() - this.method_23321();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_5974.method_43058();
                while (d4 < d3) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23317() + d0 * (d4 += 1.8 - d5 + this.field_5974.method_43058() * (1.7 - d5)), this.method_23318() + d1 * d4 + (double)this.method_5751(), this.method_23321() + d2 * d4, 0.0, 0.0, 0.0);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    private int getFriendsCount(class_1309 attackTarget) {
        if (this.method_5968() == null) {
            return 0;
        }
        float dist = ((Integer)IafCommonConfig.INSTANCE.cockatrice.chickenSearchLength.getValue()).intValue();
        List list = this.method_37908().method_18467(EntityCockatrice.class, this.method_5829().method_1012((double)dist, (double)dist, (double)dist));
        int i = 0;
        for (EntityCockatrice cockatrice : list) {
            boolean bothLooking;
            if (cockatrice.method_5779((class_1297)this) || cockatrice.method_5968() == null || cockatrice.method_5968() != this.method_5968() || !(bothLooking = EntityGorgon.isEntityLookingAt((class_1309)cockatrice, cockatrice.method_5968(), 0.6f) && EntityGorgon.isEntityLookingAt(cockatrice.method_5968(), (class_1309)cockatrice, 0.6f))) continue;
            ++i;
        }
        return i;
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean shouldStareAttack(class_1297 entity) {
        return this.method_5739(entity) > 5.0f;
    }

    public int getAttackDuration() {
        return 80;
    }

    private boolean shouldMelee() {
        boolean blindness;
        boolean bl = blindness = this.method_6059(class_1294.field_5919) || this.method_5968() != null && this.method_5968().method_6059(class_1294.field_5919);
        if (this.method_5968() != null) {
            if ((double)this.method_5739((class_1297)this.method_5968()) < 4.0) {
                return true;
            }
            class_1309 entity = this.method_5968();
            return entity.method_5864().method_20210(IafEntityTags.COCKATRICE_TARGETS) || blindness || !this.canUseStareOn((class_1297)this.method_5968());
        }
        return false;
    }

    public void method_6091(class_243 motionVec) {
        if (!this.canMove() && !this.method_5782()) {
            motionVec = motionVec.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(motionVec);
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_JUMPAT, ANIMATION_WATTLESHAKE, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_EAT};
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean isTargetBlocked(class_243 target) {
        class_243 Vector3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        return this.method_37908().method_17742(new class_3959(Vector3d, target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.COCKATRICE_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)IafSounds.COCKATRICE_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.COCKATRICE_DIE.get();
    }

    public void method_5711(byte id) {
        if (id == 45) {
            this.playEffect(true);
        } else if (id == 46) {
            this.playEffect(false);
        } else {
            super.method_5711(id);
        }
    }

    protected void playEffect(boolean play) {
        class_2400 enumparticletypes = class_2398.field_11201;
        if (!play) {
            enumparticletypes = class_2398.field_11209;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)enumparticletypes, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }
}

